# AI 代码编辑器

> 更专业、更强大的 Vibe Coding 开发方式



你好，我是鱼皮。

在前面的文章中，我们学习了零代码平台和 AI 智能体平台的使用方法。如果你已经用这些工具做出了几个项目，可能会开始感觉到一些局限：

- 我想修改某个具体的文件，但零代码平台不够灵活......
- 项目越来越大，在浏览器里管理代码有点吃力......
- 我想学习更专业的开发方式，但又不想放弃 AI 的帮助......

如果你有这些想法，那么恭喜你，是时候升级到 AI 代码编辑器了！

AI 代码编辑器结合了传统代码编辑器的强大功能和 AI 的智能辅助，让你可以更灵活、更专业地开发项目。这篇文章，我会详细讲解主流的 AI 代码编辑器 Cursor，并分享更多值得关注的 AI 代码编辑器。



## 一、什么是 AI 代码编辑器？

在搞清楚 AI 代码编辑器之前，我们先来理解一个基本概念：什么是代码编辑器？

简单来说，**代码编辑器就是程序员写代码的工具**，就像 Word 是写文档的工具一样。常见的代码编辑器有 VS Code、Sublime Text、Notepad++ 等。

还有一个相关的概念叫 **IDE（集成开发环境）**，它比代码编辑器功能更强大，不仅能写代码，还集成了调试、编译、版本控制等一整套开发工具。常见的 IDE 有 JetBrains 公司的 IntelliJ IDEA、PyCharm、WebStorm 等。

不过在实际使用中，代码编辑器和 IDE 的界限已经越来越模糊了。比如 VS Code 虽然叫编辑器，但通过安装插件，功能已经和 IDE 差不多了。所以你不用太纠结这两个概念的区别，知道它们都是写代码的工具就行。

现在我们来搞清楚 2 个问题：

- AI 代码编辑器和零代码平台有什么区别？
- AI 代码编辑器和传统代码编辑器有什么区别？



### AI 代码编辑器 PK 零代码平台

零代码平台是在浏览器里用的，你通过对话让 AI 生成整个应用，特别适合快速做原型和简单项目。而 AI 代码编辑器需要下载安装到电脑，可以精确控制每个文件、每行代码，而且有完整的开发工具链（比如代码调试、版本控制等），更适合复杂项目和专业开发。

打个比方，零代码平台就像在餐厅点菜，厨师做好端上来；AI 代码编辑器则像在自己厨房做菜，有个智能助手在旁边帮你。



### AI 代码编辑器 PK 传统代码编辑器

那 AI 代码编辑器和传统的代码编辑器（比如 VS Code、JetBrains、Sublime Text）又有什么区别呢？

我认为，最大的区别是 **AI 的深度集成**。

传统代码编辑器只是一个写代码的工具，你需要自己想清楚每一行代码怎么写。而 AI 代码编辑器内置了强大的 AI 助手，可以帮你生成代码、解释代码、修改代码、甚至自动执行多文件任务。

具体来说，AI 代码编辑器有这些传统编辑器没有的能力：

- 用自然语言描述需求就能生成代码
- AI 能理解整个项目的上下文
- 可以自动修改多个文件
- 能自动执行命令（比如安装依赖）
- 有智能代码补全（比传统补全聪明得多）

简单来说，传统代码编辑器是 “你自己写代码的工具”，AI 代码编辑器是 “AI 帮你写代码的工具”。实际使用中，效率差距可能是 10 倍以上。

如果你有一定的编程基础，上手 AI 代码编辑器会非常快。



## 二、Cursor 最火的 AI 代码编辑器

Cursor 是目前最火的 AI 代码编辑器，被称为 “AI 时代的 VS Code”。因为它基于 VS Code 改造，保留了 VS Code 的所有优点，同时加入了强大的 AI 功能。

![](https://pic.yupi.icu/1/image-20260107133923123.png)

Cursor 的核心优势：

1. 多种 AI 功能：Tab 代码补全、Agent 智能体、Chat 对话、内联编辑等
2. 多模型支持：可以使用 Claude、GPT、Gemini、Grok 等多个模型，还有 Auto 自动选择功能
3. 上下文感知：AI 能理解整个项目的代码，支持最高 1M Token 的上下文（Max 模式）
4. 生态成熟：基于 VS Code 开发，支持所有 VS Code 插件



### Cursor 的核心 AI 功能

Cursor 最强大的地方在于它提供了多种 AI 功能，适合不同的场景。



#### 1、Tab 代码补全

这是最基础的功能，类似于 GitHub Copilot。当你写代码时，AI 会自动预测你要写什么，按 Tab 键就能接受建议。

![](https://pic.yupi.icu/1/image-20260107134002087.png)

这个功能特别适合写重复性代码、补全函数实现、快速生成样板代码。优点是速度快，不会打断思路；缺点是只能补全，不能做大的修改。



#### 2、Agent 智能体

这是 Cursor 2.0 推出的最强大功能，也是最接近 AI 程序员的模式。在这个模式下，AI 可以同时修改多个文件、自动创建新文件、执行命令（比如安装依赖）、理解整个项目结构、甚至使用浏览器测试。

你可以用它来添加新功能（需要修改多个文件）、重构代码、修复复杂 Bug、搭建项目框架等，可以处理各种复杂任务。

Cursor 还推出了自研的 **Composer 模型**，这是一个专门为软件工程优化的 AI 模型，生成速度比同类模型快 4 倍。

举个例子：
```
请添加用户认证功能，包括：
- 登录页面
- 注册页面
- 认证中间件
- 用户数据库模型
```

Agent 会自动分析项目，安装必要的依赖包、创建需要的文件、修改相关代码，直到完成任务。

![](https://pic.yupi.icu/1/image-20260107134332952.png)



#### 3、Chat 对话和内联编辑

Chat 是最常用的功能。你可以选中一段代码，然后用自然语言告诉 AI 你想做什么。可以用它来解释代码的作用、修改某个函数、修复 bug、优化性能等等。

![](https://pic.yupi.icu/1/image-20260107134511105.png)

内联编辑则可以让你直接在代码中修改，按 `Cmd/Ctrl + K` 快速调用，AI 会在当前位置生成或修改代码。

![](https://pic.yupi.icu/1/image-20260107134532921.png)

举些例子，你可以选中一段代码，然后跟 AI 说：
- 这个函数的作用是什么？
- 帮我优化一下性能
- 加上错误处理



### 怎么使用 Cursor？

让我用一个完整的例子来演示 Cursor 的使用流程。

比如我想做一个仿真的电子黑板，想画什么就画什么，还能导出为图片。

挥毫泼墨，好不痛快！

1）首先，到 [Cursor 官网](https://cursor.com) 下载适合你系统的版本（Windows/Mac/Linux 都支持）。

2）创建一个空的文件夹，用于存放整个项目代码。推荐名称为英文，比如 `yupi-drawboard` 。

然后打开 Cursor，打开刚刚创建的文件夹。

![](https://pic.yupi.icu/1/image-20260107142103143.png)

3）打开 Agent 面板，选择 Agent 模式和大模型，然后输入提示词来描述你的需求：

```
帮我开发一个仿真的电子黑板，用户可以在上面画画并导出为图片
```

![](https://pic.yupi.icu/1/image-20260107142244095.png)

接下来喝杯咖啡，等待 AI 生成代码就好。它会自动创建多个文件，你可以在 Agent 面板中看到它的工作进度。

![](https://pic.yupi.icu/1/image-20260107142422465.png)

4）几分钟之后，AI 生成了完整的代码。你可以选择全部接受或者全部拒绝，也可以自己选择接受哪些代码：

![](https://pic.yupi.icu/1/image-20260107142737589.png)

5）由于需求比较简单，直接在浏览器中打开 `index.html`  网页文件，就能看到运行效果了。

![](https://pic.yupi.icu/1/image-20260107142906255.png)

效果还不错吧？猜猜我写的是什么~

6）如果需要修改细节或者修复 Bug，也是直接跟 AI 对话即可。

当然，如果你有一定的编程基础，可以自己选中某段代码，按 `Cmd/Ctrl + K` 使用内联编辑。

![](https://pic.yupi.icu/1/image-20260107142631274.png)

当你自己写新代码时，AI 会自动提示（Tab 补全功能），按 Tab 接受建议就行。

这就是 Cursor 的基本用法。此外 Cursor 还支持联网搜索、使用浏览器、语音输入、MCP 插件等更多能力，后续可以慢慢探索。



### Cursor 的优缺点

Cursor 是我目前用过的功能最全面的 AI 代码编辑器，它的几种 AI 模式覆盖了从代码补全到智能体的所有场景。

因为基于 VS Code，所有 VS Code 的插件、主题、快捷键都能用，如果你之前用过 VS Code，上手会非常快。

而且你可以在 Claude、GPT、Gemini 等主流新模型之间自由切换，还能使用自己的大模型和 API Key。

![](https://pic.yupi.icu/1/1764145641557-9b0b777f-f9ca-4cb4-8566-437dbd4b2cbb.png)

此外，Cursor 的用户量很多，遇到问题比较容易找到解决方案，网上的教程、视频也最多，鱼皮自己也是一直在关注 Cursor 的发展动态，也做过不少教程。

不过 Cursor 最大的硬伤还是价格，高级套餐本身价格就比较贵，每个套餐还有用量的限制。

当你超出每月包含的用量时，可以选择添加按需用量（按 API 费率计费）或者升级到更高档位。不同模型的 API 成本不同，你的模型选择会影响用量消耗速度。

详细的价格信息和用量计算，建议查看 [Cursor 官方定价文档](https://cursor.com/cn/docs/account/pricing)，那里有最新最准确的信息。

如果你认真学习 Vibe Coding，我推荐订阅 Pro 版。20 刀换来的效率提升，对大多数人来说是值得的。如果你是重度用户，每天大量使用 Agent，可以考虑 Pro Plus 或 Ultra。

像鱼皮这种 Cursor 重度患者，即使开了高级套餐，也得承受天价账单……

![](https://pic.yupi.icu/1/yupicursorbilling.png)

此外，Agent 模式处理复杂任务时可能需要等待较长时间。虽然有 AI 辅助，但还是需要一定的编程基础，完全零基础的新手可能会觉得有点复杂。

更多 Cursor 的使用技巧和省钱方法，可以查看本系列教程的【进阶选学：经验技巧】板块，那里有详细的讲解。





## 三、其他主流 AI 代码编辑器

除了 Cursor，市面上还有一些其他的 AI 代码编辑器值得了解。



### Windsurf

[Windsurf](https://codeium.com/windsurf) 是 Codeium 公司推出的 AI 代码编辑器，最大的优势是完全免费。用完额度后，Windsurf 仍可免费使用，特别适合学生和预算有限的开发者。

并且提供了 Cascade 智能体模式（类似 Cursor 的 Agent），用自然语言描述需求，AI 会自动创建和修改多个文件。最大的优势是完全免费

![](https://pic.yupi.icu/1/image-20260107135727334.png)



### Antigravity

[Antigravity](https://antigravity.google) 是 Google 推出的智能体开发平台，界面类似 VS Code。它采用 Agent 优先的设计，AI 智能体可以自主规划、执行和验证复杂任务。

它集成了 Gemini 等大模型，支持 1M Token 上下文，适合想尝试 Google AI 生态、需要超长上下文的大型项目的开发者。

![](https://pic.yupi.icu/1/image-20260107135834072.png)



### Kiro

[Kiro](https://kiro.dev) 是 Amazon 推出的 AI IDE，强调 “规范驱动开发”。先写需求规范，再让 AI 实现。

它和 AWS 深度集成，可以直接部署到 AWS 服务，适合使用 AWS 服务的开发者、需要规范化开发流程的团队、做企业级应用的场景。

![](https://pic.yupi.icu/1/image-20260107135922286.png)



### TRAE

[TRAE](https://www.trae.ai) 是字节跳动推出的 AI 原生编程工具。有 2 种开发模式：

- IDE 模式类似 Cursor，保留传统开发流程
- SOLO 模式让 AI 主导，自动推进开发任务

TRAE 的 SOLO 模式是它最大的亮点，区别于传统的人类主导 + AI 辅助编程，SOLO 模式让 AI 主导任务并自动执行开发。你只需要有一个想法，AI 就能自动生成产品需求文档、技术架构文档，然后自主编写代码、安装依赖、测试验证，直到项目可以正常运行。

而且 TRAE 支持集成第三方服务，比如 Supabase 数据库、Stripe 支付、OpenRouter AI 服务等，不用看文档就能傻瓜式集成。可以帮你快速开发包含完整前端和后端的商业级产品。

![](https://pic.yupi.icu/1/image-20250928222329915.png)

国内版的 TRAE 很适合中文用户，访问速度快。鱼皮用 TRAE SOLO 开发过微信小程序，感兴趣的可以看看 [实战视频](https://www.bilibili.com/video/BV1yMn3zuE7L)。



### Zed

[Zed](https://zed.dev) 是用 Rust 编写的高性能代码编辑器，由 Atom 的创始团队打造。内置 AI 助手、支持多种 AI 模型、支持实时协作编辑。

优点是启动速度极快、占用资源少。适合追求极致性能、电脑配置一般、需要团队协作的开发者。

![](https://pic.yupi.icu/1/windows-multibuffer.jpeg)



## 四、怎么选择 AI 代码编辑器？

看到这里，你可能会问：这么多 AI 代码编辑器，我该选哪个呢？

其实选择很简单，主要看你的需求和预算。

**优先推荐 Cursor**。截止到目前，Cursor 仍然是功能最强大、生态最成熟的 AI 代码编辑器，我自己主力也是用 Cursor 做项目开发。

前面也提到过，它的优势包括：

- 功能全面：Tab、Agent、Chat、内联编辑等
- 更新快：经常推出新功能
- 上下文理解能力强：支持最高 1M Token
- 多模型支持：可以自由切换 Claude、GPT、Gemini 等，第一时间对接新模型
- 生态成熟：基于 VS Code，所有插件都能用
- 社区活跃：遇到问题很容易找到解决方案

如果你预算充足（每月 20 美元以上），Cursor 是首选。如果你预算有限，Windsurf 是很好的免费选择，虽然功能相对简单，但对学习来说完全够用。



## 五、AI 代码编辑器实战技巧

无论你选择 Cursor 还是其他 AI 代码编辑器，下面这些实战技巧都能帮你提升效率。

### 1、善用上下文

AI 代码编辑器最强大的地方在于它能理解整个项目的上下文。要充分利用这一点：

- 在项目根目录创建 `README.md`，描述项目的整体架构
- 使用 `.cursorrules`（或者其他编辑器支持的规则文件），告诉 AI 你的编码规范
- 在对话时，引用相关的文件（`@文件名`）

举个例子：
```
参考  @src/components/ImageUploader.vue 的代码风格，创建一个 Card 组件
```

![](https://pic.yupi.icu/1/image-20260107140926938.png)



### 2、分步骤实现

不要一次性提出太复杂的需求，而是分步骤来：

❌ 不好的方式：
```
做一个完整的电商网站
```

✅ 推荐的方式：
```
第一步：创建商品列表页面
第二步：添加商品详情页面
第三步：添加购物车功能
第四步：添加结算功能
```



### 3、利用快捷键

熟练使用快捷键可以大大提升效率。

以 Cursor 为例，建议尝试下面这些快捷键，能让你少用鼠标，操作更快。

对话相关：
- `Cmd/Ctrl + L` ：切换侧边栏（除非已绑定到某个模式）
- `Cmd/Ctrl + I` ：切换侧边栏（除非已绑定到某个模式）
- `Cmd/Ctrl + K` ：打开行内编辑，可以在当前位置插入 AI 生成的代码
- `Tab`：接受建议

代码编辑：
- `Cmd/Ctrl + Shift + L` ：将选中内容添加到聊天
- `Alt + ↑/↓` ：移动当前行
- `Cmd/Ctrl + /` ：注释/取消注释

文件操作：
- `Cmd/Ctrl + Shift + F` ：全局搜索

更多最新的默认键盘快捷键以 [官方文档](https://cursor.com/cn/docs/configuration/kbd) 为主：

![](https://pic.yupi.icu/1/image-20260104192219087.png)



### 4、代码审查

AI 生成的代码不一定完美，要养成审查的习惯。

检查一下代码逻辑是否正确、有没有安全隐患、性能是否合理、代码风格是否统一。

当然，你也可以让 AI 帮你审查：

```
请审查这段代码，指出潜在的问题
```



### 5、保存重要版本

Git 是目前最主流的分布式版本控制系统（Version Control System），是团队协作开发不可或缺的工具。它可以保存和管理文件的所有更新记录、并且使用 **版本号** 进行区分。从而支持将编辑后的文档恢复到修改前的状态、对比不同版本的文件差异、防止旧版本覆盖新版本等功能。

在做重大修改之前，记得提交 Git：

```bash
git add .
git commit -m "添加用户认证功能前的版本"
```

这样如果 AI 改坏了，可以随时回退。

💡 如果想深入学习 Git 和 GitHub，可以看看鱼皮的 [Git & GitHub 保姆级学习路线](https://www.codefather.cn/course/1789189862986850306/section/1789190804671012866)，完全免费。



### 6、善用终端

AI 代码编辑器都内置了终端，可以直接运行命令。这样你不需要切换到其他窗口，就能在编辑器里完成所有操作。

比如常用的前端开发命令：

```bash
# 安装依赖
npm install

# 运行开发服务器
npm run dev

# 运行测试
npm test
```

Cursor 还支持在终端中生成命令：

![](https://pic.yupi.icu/1/image-20260107141312489.png)

不用记忆这些命令！如果使用了 Agent 模式，AI 可能会自动执行这些命令，无需你手动输入。



### 7、学习生成的代码

使用 AI 代码编辑器的过程，也是一个很好的学习机会。AI 生成的代码可能使用了一些你不熟悉的技术和库，这正是学习的好时机。

因此，不要只是让 AI 生成代码就完事了，要尝试理解它。看不懂的地方，直接问 AI：“这段代码是什么意思？”

还可以尝试修改代码，看看会发生什么。这样你不仅能完成项目，还能学到真正的编程知识，慢慢地成长为一位专业的程序员（Vibe Coding 版）。



## 写在最后

看到这里，相信你已经对 AI 代码编辑器有了全面的了解。

**AI 代码编辑器是从 “会用 AI” 到 “专业开发” 的关键一步。**

它让你可以更灵活地控制代码、处理更复杂的项目、学习更专业的开发方式、积累真正的编程能力。

我的建议是，不要被工具的复杂性吓到，大胆尝试。马上就下载 Cursor 或者其他 AI 代码编辑器，尝试把之前在零代码平台做的项目，用 AI 代码编辑器重新实现一遍。虽然一开始可能有点不适应，但很快就能体会到它的强大。

在下一篇文章中，我会介绍命令行工具，带你体验更高级、更极客的 Vibe Coding 方式。

加油！




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
